/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.popupevents.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonHolder {
    private JsonObject object;
    private boolean parsedCorrectly = true;

    public JsonHolder(JsonObject object) {
        this.object = object;
    }

    public JsonHolder(String raw) {
        if (raw == null || raw.isEmpty()) {
            this.object = new JsonObject();
            return;
        }
        try {
            this.object = new JsonParser().parse(raw).getAsJsonObject();
        }
        catch (Exception e) {
            this.object = new JsonObject();
            this.parsedCorrectly = false;
            e.printStackTrace();
        }
    }

    public JsonHolder() {
        this(new JsonObject());
    }

    public boolean isParsedCorrectly() {
        return this.parsedCorrectly;
    }

    public String toString() {
        if (this.object != null) {
            return this.object.toString();
        }
        return "{}";
    }

    public JsonHolder put(String key, boolean value) {
        this.object.addProperty(key, Boolean.valueOf(value));
        return this;
    }

    public void mergeNotOverride(JsonHolder merge) {
        this.merge(merge, false);
    }

    public void mergeOverride(JsonHolder merge) {
        this.merge(merge, true);
    }

    public void merge(JsonHolder merge, boolean override) {
        JsonObject object = merge.getObject();
        for (String s : merge.getKeys()) {
            if (!override && this.has(s)) continue;
            this.put(s, object.get(s));
        }
    }

    private void put(String s, JsonElement element) {
        this.object.add(s, element);
    }

    public JsonHolder put(String key, String value) {
        this.object.addProperty(key, value);
        return this;
    }

    public JsonHolder put(String key, int value) {
        this.object.addProperty(key, (Number)value);
        return this;
    }

    public JsonHolder put(String key, double value) {
        this.object.addProperty(key, (Number)value);
        return this;
    }

    public JsonHolder put(String key, long value) {
        this.object.addProperty(key, (Number)value);
        return this;
    }

    public JsonHolder optJSONObject(String key, JsonObject fallBack) {
        try {
            return new JsonHolder(this.object.get(key).getAsJsonObject());
        }
        catch (Exception e) {
            return new JsonHolder(fallBack);
        }
    }

    public JsonArray optJSONArray(String key, JsonArray fallback) {
        try {
            return this.object.get(key).getAsJsonArray();
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public JsonArray optJSONArray(String key) {
        return this.optJSONArray(key, new JsonArray());
    }

    public boolean has(String key) {
        return this.object.has(key);
    }

    public long optLong(String key, long fallback) {
        try {
            return this.object.get(key).getAsLong();
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public boolean optBoolean(String key, boolean fallback) {
        try {
            return this.object.get(key).getAsBoolean();
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public JsonObject optActualJSONObject(String key) {
        try {
            return this.object.get(key).getAsJsonObject();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public JsonHolder optJSONObject(String key) {
        return this.optJSONObject(key, new JsonObject());
    }

    public int optInt(String key, int fallBack) {
        try {
            return this.object.get(key).getAsInt();
        }
        catch (Exception e) {
            return fallBack;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public String optString(String key, String fallBack) {
        try {
            return this.object.get(key).getAsString();
        }
        catch (Exception e) {
            return fallBack;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public double optDouble(String key, double fallBack) {
        try {
            return this.object.get(key).getAsDouble();
        }
        catch (Exception e) {
            return fallBack;
        }
    }

    public List<String> getKeys() {
        return this.object.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public double optDouble(String key) {
        return this.optDouble(key, 0.0);
    }

    public JsonObject getObject() {
        return this.object;
    }

    public boolean isNull(String key) {
        return this.object.has(key) && this.object.get(key).isJsonNull();
    }

    public JsonHolder put(String values, JsonHolder values1) {
        return this.put(values, values1.getObject());
    }

    public JsonHolder put(String values, JsonObject object) {
        this.object.add(values, (JsonElement)object);
        return this;
    }

    public void putArray(String blacklisted, JsonArray jsonElements) {
        this.object.add(blacklisted, (JsonElement)jsonElements);
    }

    public void remove(String header) {
        this.object.remove(header);
    }

    public List<String> getJsonArrayAsStringList(String root) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            for (JsonElement element : this.object.get(root).getAsJsonArray()) {
                strings.add(element.getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strings;
    }
}

